:: http://zone54.com
@ECHO OFF
CHCP 1252 1>NUL
TITLE WinXP-IE - Windows Movie Maker Setup
Set "BatchDir=%~dp0"
If [%BatchDir:~-1%]==[\] Set "BatchDir=%BatchDir:~0,-1%"

:: Movie Maker:
Set "Version=2.1.4028.0 Plus"

ECHO                                      \\!//
ECHO                                      (o o)
ECHO ---------------------------------oOOo-(_)-oOOo---------------------------------
ECHO Installation of Windows Movie Maker %Version%.
ECHO ===============================================================================
ping -n 1 localhost 1>NUL

FLTMC >NUL 2>&1 || PowerShell Start-Process -FilePath '%0' -Verb RunAs >NUL 2>&1 && EXIT /b
FLTMC >NUL 2>&1 && GoTo OSC
COLOR 0c
ECHO.
ECHO ERROR: This Batch script must be run with full administrative privileges.
ECHO Please log on with a User Account that has full administrative privileges.
ECHO.
PAUSE
EXIT
:OSC
VER | FindStr /l "5.1" 1>NUL && GoTo CorrectOS || GoTo IncorrectOS
:IncorrectOS
COLOR 06
ECHO.
ECHO Windows Movie Maker %Version% was made for Windows XP 32-bit.
ECHO Do you still want to continue with the installation?
PAUSE
COLOR 07
GoTo SKIP
:CorrectOS
ECHO.
ECHO Do you want to INSTALL Windows Movie Maker %Version%?
PAUSE
:SKIP

ECHO.
ECHO -------------------------------------------------------------------------------

ECHO.
ECHO Terminating Windows Movie Maker processes . . .
TaskKill /f /im "moviemk.exe" >NUL 2>&1
ping -n 4 localhost 1>NUL

If Not Exist "%ProgramFiles%\Movie Maker\moviemk.exe" GoTo SKIP
ECHO.
ECHO Unregistering Old Windows Movie Maker "*.dll" files . . .
RegSvr32 /u /s "%ProgramFiles%\Movie Maker\wmm2ae.dll"
RegSvr32 /u /s "%ProgramFiles%\Movie Maker\wmm2ext.dll"
RegSvr32 /u /s "%ProgramFiles%\Movie Maker\wmm2filt.dll"
RegSvr32 /u /s "%ProgramFiles%\Movie Maker\wmm2fxa.dll"
RegSvr32 /u /s "%ProgramFiles%\Movie Maker\wmm2fxb.dll"
:SKIP

ECHO.
ECHO Registering Catalog files . . .
".\signtool.exe" catdb /q "%BatchDir%\I386\MEDIACTR.CAT"
".\signtool.exe" catdb /q "%BatchDir%\I386\KB981997.CAT"

If Not Exist "%SystemRoot%\system32\dllcache\moviemk.exe" GoTo SKIP
ECHO.
ECHO Overwriting Cached files . . .
XCOPY ".\I386\moviemk.exe" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2ae.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2eres.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2ext.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2filt.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2fxa.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2fxb.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2res.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
XCOPY ".\I386\wmm2res2.dll" "%SystemRoot%\system32\dllcache\" /V /Y /Z 1>NUL
:SKIP

ECHO.
ECHO Executing "moviemk.inf" file . . . 
RunDll32.exe SetupAPI.dll,InstallHinfSection DefaultInstall 128 .\I386\moviemk.inf

ECHO.
ECHO Copying Windows Movie Maker "Uninstaller.cmd" file into
ECHO the "%ProgramFiles%\" directory . . .
XCOPY ".\Uninstaller.cmd" "%ProgramFiles%\Movie Maker\" /V /Y /Z 1>NUL

ECHO.
ECHO Adding Windows Movie Maker Registry Entries . . .
:: Uninstaller.
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "Comments" /t REG_SZ /d "Windows Media Center Edition 2005 SP3 with the Security Update KB981997." /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "DisplayIcon" /t REG_SZ /d "%ProgramFiles%\Movie Maker\moviemk.exe" /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "DisplayName" /t REG_SZ /d "Windows Movie Maker v%Version%" /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "DisplayVersion" /t REG_SZ /d "%Version%" /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "Publisher" /t REG_SZ /d "Zone 54" /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "UninstallString" /t REG_SZ /d "%ProgramFiles%\Movie Maker\Uninstaller.cmd" /f 1>NUL
Reg Add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Movie Maker" /v "URLInfoAbout" /t REG_SZ /d "https://zone54.com/" /f 1>NUL
:: Tweaks.
Reg Add "HKCU\Software\Microsoft\MM20\TimelineSettings" /v "Timeline/Storyboard" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Task Pane Settings" /v "Group 2 Expanded" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Task Pane Settings" /v "Group 3 Expanded" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Task Pane Settings" /v "Group 4 Expanded" /t REG_DWORD /d "0" /f 1>NUL
VER | FindStr /l "5.1 5.2" 1>NUL || GoTo NEXT
Reg Load "HKU\DefaultUserHive" "%AllUsersProfile%\..\Default User\NTUSER.DAT" 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\TimelineSettings" /v "Timeline/Storyboard" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Task Pane Settings" /v "Group 2 Expanded" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Task Pane Settings" /v "Group 3 Expanded" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Task Pane Settings" /v "Group 4 Expanded" /t REG_DWORD /d "0" /f 1>NUL
:: Adds Compatibility Filters Configuration for Windows XP.
Reg Query "HKLM\SOFTWARE\GNU" >NUL 2>&1 || GoTo SKIP
For /f "tokens=3* skip=2" %%a in ('Reg Query "HKLM\SOFTWARE\Classes\CLSID\{007FC171-01AA-4B3A-B2DB-062DEE815A1E}\InprocServer32" /ve') do Set "GNUAX=%%b"
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Path" /t REG_SZ /d "%GNUAX%" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionMin" /t REG_BINARY /d "0000000000000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionMax" /t REG_BINARY /d "ff00ff00ff00ff00" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionCurrent" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Path" /t REG_SZ /d "%GNUAX%" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionMin" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionMax" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionCurrent" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "Path" /t REG_SZ /d "%GNUAX%" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionMin" /t REG_BINARY /d "0000000000000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionMax" /t REG_BINARY /d "ff00ff00ff00ff00" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{04FE9017-F873-410E-871E-AB91661A4EF7}" /v "VersionCurrent" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "Path" /t REG_SZ /d "%GNUAX%" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionMin" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionMax" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{0F40E1E5-4F79-4988-B1A9-CC98794E6B55}" /v "VersionCurrent" /t REG_BINARY /d "0000b61103000100" /f 1>NUL
:SKIP
Reg Query "HKLM\SOFTWARE\LAV" >NUL 2>&1 || GoTo SKIP
For /f "tokens=3* skip=2" %%a in ('Reg Query "HKLM\SOFTWARE\Classes\CLSID\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}\InprocServer32" /ve') do Set "LAVAXS=%%b"
For /f "tokens=3* skip=2" %%a in ('Reg Query "HKLM\SOFTWARE\Classes\CLSID\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}\InprocServer32" /ve') do Set "LAVAXA=%%b"
For /f "tokens=3* skip=2" %%a in ('Reg Query "HKLM\SOFTWARE\Classes\CLSID\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}\InprocServer32" /ve') do Set "LAVAXV=%%b"
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Path" /t REG_SZ /d "%LAVAXS%" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Enabled" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Path" /t REG_SZ /d "%LAVAXA%" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Enabled" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Path" /t REG_SZ /d "%LAVAXV%" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKCU\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Enabled" /t REG_DWORD /d "1" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "Path" /t REG_SZ /d "%LAVAXS%" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{171252A0-8820-4AFE-9DF8-5C92B2D66B04}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Enabled" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "Path" /t REG_SZ /d "%LAVAXA%" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{E8E73B6B-4CB3-44A4-BE99-4F7BCB96E491}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Enabled" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Default" /t REG_DWORD /d "0" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "Path" /t REG_SZ /d "%LAVAXV%" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionMin" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionMax" /t REG_BINARY /d "1100020046000000" /f 1>NUL
Reg Add "HKU\DefaultUserHive\Software\Microsoft\MM20\Filters\{EE30215D-164F-4A92-A4EB-9D4C13390F9F}" /v "VersionCurrent" /t REG_BINARY /d "1100020046000000" /f 1>NUL
:SKIP
Reg UnLoad "HKU\DefaultUserHive" 1>NUL
::DEL /a:hs "%AllUsersProfile%\..\Default User\SETUPREG.HIV.LOG*" "%AllUsersProfile%\..\Default User\SETUPREG.HIV{*" 2>NUL
:NEXT

If Not "%Processor_Architecture%" == "x86" GoTo SKIP
ECHO.
ECHO Remoing Windows Movie Maker 16-bit Registry Entries . . .
Reg Delete "HKCR\Interface\{88F3B01F-9376-4D8D-8EF8-A19597B74B22}\ProxyStubClsid" /f >NUL 2>&1
Reg Delete "HKCR\Interface\{E31FB81B-1335-11D1-8189-0000F87557DB}\ProxyStubClsid" /f >NUL 2>&1
:SKIP

ECHO.
ECHO Registering Windows Movie Maker "*.dll" files . . .
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2ae.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2dvr.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2ext.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2filt.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2fxa.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\wmm2fxb.dll"
RegSvr32 /s "%ProgramFiles%\Movie Maker\MUI\0409\AddOnTfx\wmm2fxpz.dll"

ECHO.
ECHO ---------------------------------[ Finished ]----------------------------------
ping -n 5 localhost 1>NUL
EXIT
